##vif from car package
##  calculate vif's DIRECTLY from vcov

calc_vifs <- function (object, depVar="CO2", dataf=df, ...) {
require(formula.tools)
   
  m <- object
  terms <- labels(terms(m))
  xVars <- paste(terms, collapse="+")
  f <- as.formula(paste(depVar, "~", xVars))
  
  lm_model <- lm(f, data=dataf)
  V <- car::vif(lm_model)[,3] ##Using GVIF^(1/(2*Df))
  
  return(V)
}