source("myFunctions/summary_panelAR.R")
source("myFunctions/panelAR_revised.R")
pw.function <- function(f, data=NULL, method=NULL, pV=NULL, tV=NULL, ...){
  `%||%` <- function(a, b) if (!is.null(a)) a else b
  
    data <- (data %||% df)
    method <- (method %||% "m1")
   pV <- (pV %||% "ID")
   tV <- (tV %||% "YR")


    p <- panelAR_r(formula=f, data=data,
                    panelVar=pV, timeVar=tV,
                    autoCorr = "ar1", panelCorrMethod = "pcse",
                    rho.na.rm=TRUE, panel.weight='t-1', bound.rho=TRUE)

##The 4th method which uses the function pcse::vcovPC() will usually throw an error 
    ##if panels are not balanced.  By default, you must specify you want to
    ##use it, or else only the other three methods are used, which take the results directly from panelAR().  
    
if(method=="m4") { results <- fe_ar1_pcse(p, f=f, data=data, includeM4 = TRUE) }
 else {results <- fe_ar1_pcse(p, f=f, data=data)}
 out <- switch(method,
               "m1" = results$method1,
               "m2" = results$method2,
               "m3" = results$method3,
               "m4" = results$method4)
  

  p$pcses <- out$pcses
  p$tvals <- out$tvals
  p$pvals <- out$pvals
  p$coefficients2 <- out$coefficients
  
  return(p)
}



